/**
* \file: utils.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: AAUTO
*
* \author:  Veeraiyan Chidambaram /RBEI/ECF3/ veeraiyan.chidambaram@in.bosch.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include "timer_utils.h"
#include <algorithm>

using namespace std;

namespace adit { namespace aauto
{

uint64_t GetCurrentTimeNano()
{
    timespec now;
    clock_gettime(CLOCK_MONOTONIC, &now);

    uint64_t seconds = (uint64_t)now.tv_sec * 1000000000;
    uint64_t nanoseconds = now.tv_nsec;

    return seconds + nanoseconds;
}

uint64_t GetHostTicks()
{
    struct timespec ts;
    ts.tv_sec  = 0;
    ts.tv_nsec = 0;
    clock_gettime(CLOCK_MONOTONIC, &ts);
    return ((uint64_t)ts.tv_sec) * GST_SECOND + ts.tv_nsec;
}


uint64_t GetTickDifference(uint64_t inFirst, uint64_t inSecond)
{
    if (inFirst <= inSecond)
    {
        return inSecond - inFirst;
    }
    else
    {
        return inSecond + (((uint64_t)-1) - inFirst);
    }
}


/*
 * \see RFC 3550 NTP
 */
uint64_t gstToNTP64(uint64_t inGstTs)
{
    uint64_t seconds = inGstTs / GST_SECOND;
    uint64_t nanoseconds = inGstTs - seconds;
    uint64_t fraction = nanoseconds * 0xffffffff / GST_SECOND;

    // NTP64 32 bit seconds, 32 bit fraction
    return (seconds << 32) | (fraction & 0xffffffff);

    // NTP32 16 bit seconds, 16 bit fraction
    // ((seconds & 0xffff) << 16) | ((fraction >> 16) & 0xffff);
}

} } /* namespace adit { namespace aauto*/

